<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('categories', "Categories") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"> <?= labels('category', 'Categories') ?></a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="card-body">
                <h2 class='section-title'><?= labels('create_category', "Create Category") ?></h2>
                <div class="row mt-3">
                    <div class="col-md-4">
                        <?= form_open('/admin/category/add_category', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_Category', 'enctype' => "multipart/form-data"]); ?>
                        <div class="form-group">
                            <label for="name"><?= labels('name', 'Name') ?></label>
                            <input id="name" class="form-control" type="text" name="name" placeholder="Enter the name of the Category here">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="commision"><?= labels('commision', 'Commision') ?>(%)<small>( <?= labels('commision', 'Commision') ?>(%)<?= labels('commision_note', 'to be given to the Super Admin on Service') ?>.)</small></label>
                            <input id="commision" class="form-control" type="text" name="commision" placeholder="Enter the commission for the Category here" min="0">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="make_parent"><?= labels('type', 'Type') ?></label><br>
                            <select name="make_parent" id="make_parent" class="form-control">
                                <option value="0"><?= labels('category', 'Category') ?></option>
                                <option value="1"><?= labels('sub_category', 'Sub Category') ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row" id="parent">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="category_ids"><?= labels('select_parent_category', 'Select Parent Category') ?></label><br>
                            <select name="parent_id" id="category_ids" class="form-control">
                                <option value=""><?= labels('select_parent_category', 'Select Parent Category') ?></option>
                                <?php foreach ($categories as $category) : ?>
                                    <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    

                    <div class="col-md-4">
                        <div class="form-group"> <label for="image"><?= labels('image', 'Image') ?></label>
                            <div class="file-upload">
                                <div class="file-select" style="border-radius: 0.25rem;">
                                    <div class="file-select-button" id="fileName"><?= labels('choose_file', 'Choose File') ?></div>
                                    <div class="file-select-name" id="noFile"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                    <input type="file" name="image" id="image" accept="image/*" onchange="readURL(this)">
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="color"><?= labels('dark_theme_color', 'Dark Theme Color') ?></label>
                            <br>
                            <input type="color" name="dark_theme_color" id="dark_theme_color" title="Choose Color" />
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="color"><?= labels('light_theme_color', 'Light Theme Color') ?></label>
                            <br>
                            <input type="color" name="light_theme_color" id="light_theme_color" title="Choose Color" />
                        </div>
                    </div>


                    <div class="col-md-4">
                        <div class="custom-control custom-switch mt-4">
                            <input class="custom-control-input" type="checkbox" name="changer" id="changer" checked>
                            <label class="custom-control-label" for="changer">
                                <p id="category_para" class="ml-10">
                                    <?= labels('enable', 'Enable') ?>
                                </p>
                            </label>
                        </div>
                    </div>

                    <div class="col-md-4" id="category_image_section">
                        <div id="categoryImage" style="width: 200px; height: 150px; border: 1px solid ;border-color: #e4e6fc;border-radius: 0.35rem;margin-bottom:25px ">
                            <div class="form-group image">
                                <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" style="display: block;margin-left: auto;margin-top: 25px;margin-right: auto;width: 80%;" alt="category Image" width="50%" height="100px" id="service_image">
                            </div>
                        </div>
                    </div>




                </div>


                <div class="row">
                    <div class="col-md">
                        <div>
                            <button type="reset" class="btn btn-warning"> <?= labels('Reset', 'Reset') ?></button>
                            <button type="submit" class="btn btn-success"><?= labels('add_category', 'Add Category') ?></button>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title'> <?= labels('category_list', 'Category List') ?></h2>
            <div class="row pb-3">
                <div class="col-12">
                    <table class="table table-striped" id="category_list" data-detail-formatter="category_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/categories/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="parent_id" class="text-center" data-sortable="true"><?= labels('parent_Id', 'Parent Id') ?></th>
                                <th data-field="parent_category_name" class="text-center"><?= labels('parent_category_name', 'Parent Category Name') ?></th>
                                <th data-field="name" class="text-center" data-sortable="true"><?= labels('name', 'Name') ?></th>
                                <th data-field="category_image" class="text-center"><?= labels('image', 'Image') ?></th>
                                <th data-field="admin_commission" class="text-center"><?= labels('admin_commission', 'Admin Commission') ?></th>
                                <th data-field="status" class="text-center" data-sortable="true"><?= labels('status', 'Status') ?></th>
                                <th data-field="dark_color_format" class="text-center" data-visible="false"><?= labels('dark_theme_color', 'Dark Color') ?></th>
                                <th data-field="light_color_format" class="text-center" data-visible="false"><?= labels('light_theme_color', 'Light Color') ?></th>

                                <th data-field="created_at" class="text-center" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                <th data-field="operations" class="text-center" data-events="Category_events"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?= labels('update_category', 'Update Category') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?= form_open('admin/category/update_category', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_Category', 'enctype' => "multipart/form-data"]); ?>
                    <div class="row">
                        <!-- <div class="col-md-6">
                            <div class="form-group">
                                <label for="name"><?= labels('parent_category', 'Parent Category') ?></label> <br>
                                <select name="parent_id_edit" id="parent_id_edit" class="form-control">
                                    <option value=""><?= labels('select_parent_category', 'Select Parent Category') ?></option>
                                    <?php foreach ($categories as $category) : ?>
                                        <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div> -->

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="edit_make_parent"><?= labels('type', 'Type') ?></label><br>
                                <select name="edit_make_parent" id="edit_make_parent" class="form-control">
                                    <option value="0"><?= labels('category', 'Category') ?></option>
                                    <option value="1"><?= labels('sub_category', 'Sub Category') ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name"><?= labels('name', 'Name') ?></label>
                                <input id="edit_name" class="form-control" type="text" name="name" placeholder="Enter the name of the Category here">
                            </div>
                        </div>
                    </div>
                    <div class="row" id="edit_parent">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="category_ids"><?= labels('select_parent_category', 'Select Parent Category') ?></label><br>
                                <select name="edit_parent_id" id="edit_category_ids" class="form-control">
                                    <option value=""><?= labels('select_parent_category', 'Select Parent Category') ?></option>
                                    <?php foreach ($categories as $category) : ?>
                                        <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="id" id="id">

                    <div class="row">



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="commision"><?= labels('commision', 'Commision') ?></label>
                                <input id="commision_1" class="form-control" type="number" name="commision_1" placeholder="Enter the commission for the Category here" min="0">
                            </div>
                        </div>

                        <div class="col-md-6">

                            <div class="custom-control custom-switch mt-4">

                                <input type="checkbox" class="custom-control-input changer_ed" id="changer_1" name="changer_1" checked>
                                <label class="custom-control-label" for="changer_1">
                                    <p id="category_para_edit" class="ml-10">
                                        <?= labels('enable', 'Enable') ?>
                                    </p>
                                </label>
                            </div>
                        </div>

                    </div>

                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <!-- <div class="input-group mb-3"> -->
                                <div class="mb-3">
                                    <?= labels('image', "Image") ?>
                                    <div class="file-upload">
                                        <div class="file-select" style="border-radius: 0.25rem;">
                                            <div class="file-select-button" id="fileName1"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile1"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                            <input type="file" name="image" id="formFile" accept="image/*" onchange="loadFile(event)">
                                        </div>
                                    </div>
                                    <!-- <input class="form-control" type="file" id="formFile" name="image" accept="image/*" onchange="loadFile(event)"> -->
                                </div>
                                <!-- </div> -->
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="color"><?= labels('dark_theme_color', 'Dark Theme Color') ?></label>
                                <br>
                                <input type="color" name="edit_dark_theme_color" id="edit_dark_theme_color" title="Choose Color" />
                            </div>
                        </div>


                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="color"><?= labels('light_theme_color', 'Light Theme Color') ?></label>
                                <br>
                                <input type="color" name="edit_light_theme_color" id="edit_light_theme_color" title="Choose Color" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div id="edit_categoryImage" style="width: 200px; height: 150px; border: 1px solid ;border-color: #e4e6fc;border-radius: 0.35rem;margin-bottom:25px ">
                                <!-- <img src="" alt="old_image" style="width: 48" id="category_image" class="w-50" id="update_service_image"> -->
                                <img src="" alt="old_image" style="display: block;margin-left: auto;margin-top: 25px;margin-right: auto;width: 80%;" width="50%" height="100px" id="category_image" id="update_service_image">
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary"><?= labels('save_changes', "Save changes") ?></button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', "Close") ?></button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var picker1 = document.getElementById('dark_theme_color');
    var box1 = document.getElementById('categoryImage');
    picker1.addEventListener('change', function() {
        box1.style.backgroundColor = this.value;
    })



    var picker2 = document.getElementById('light_theme_color');
    var box2 = document.getElementById('categoryImage');
    picker2.addEventListener('change', function() {
        box2.style.backgroundColor = this.value;
    })

    var picker3 = document.getElementById('edit_light_theme_color');
    var box3 = document.getElementById('edit_categoryImage');
    picker3.addEventListener('change', function() {
        box3.style.backgroundColor = this.value;
    })

    var picker4 = document.getElementById('edit_dark_theme_color');
    var box4 = document.getElementById('edit_categoryImage');
    picker4.addEventListener('change', function() {
        box4.style.backgroundColor = this.value;
    })

    $('#image').bind('change', function() {
        var filename = $("#image").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile").text(filename.replace("C:\\fakepath\\", ""));
        }
    });

    $('#formFile').bind('change', function() {
        var filename = $("#formFile").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile1").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile1").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
</script>